<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nickname', 'profile_id', 'login_type');

    public function loginType()
    {
        return $this->hasOne('App\Models\LoginType');
    }

    public function profile()
    {
        return $this->hasOne('App\Models\UserProfile');
    }

}